#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Trippy StarsMod01.fsh   by r33v01v3  
//https://www.shadertoy.com/view/sld3R4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//r33v01v3 2021
//thanks to BigWIngs for getting me into this via his tutorials

#define S(a,b,t) smoothstep(a,b,t)

vec2 rotateUV(vec2 uv, float rotation){
    float mid = 0.0;
    return vec2(
        cos(rotation) * (uv.x - mid) + sin(rotation) * (uv.y - mid) + mid,
        cos(rotation) * (uv.y - mid) - sin(rotation) * (uv.x - mid) + mid
    );
}
float sdHexagram( in vec2 p, in float r ){
    const vec4 k = vec4(-0.5,0.8660254038,0.5773502692,1.7320508076);
    p = abs(p);
    p -= 2.0*min(dot(k.xy,p),0.0)*k.xy;
    p -= 2.0*min(dot(k.yx,p),0.0)*k.yx;
    p -= vec2(clamp(p.x,r*k.z,r*k.w),r);
    return length(p)*sign(p.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float t = iTime;
    vec4 bcol = vec4(vec3(0.1),1.0);//background colour
	vec3 finalColour = vec3(1.0,0.0,abs(sin(t*0.5)));//main colour
	float off = 0.0;//rotate offset
	float timeoff = 1.06;//sync for rotation
	float size = 5.0;//scale
	float sc = 1.0;//division value
	float layerBrightness = 0.05;//starting"brightness"
    vec4 tc = vec4(0.0);
    
	for(int i = 0; i < 20; i ++){
    float colval = float(i)*0.0062;//layer colour gradient
	vec2 uv = (fragCoord.xy-0.5*iResolution.xy)/iResolution.y;
	uv = rotateUV(uv, sin(t+off)*timeoff);

	float st = sdHexagram(uv*(size/sc),1.0);//shape 1
	float cr = sdHexagram(uv*(size/sc),5.0);//shape 2

	float tm = mix(st,cr,clamp(sin(t*0.1),-0.2,0.8));//morph shapes
    
	float ts = S(1.0,0.8,tm);//layer blur

    tc = vec4(finalColour*layerBrightness,ts);
    finalColour.r -= colval;
    finalColour.gb += colval;
    
    bcol = mix(bcol,tc,tc.a);

	sc -= 0.05;
	off += clamp(sin(t*0.1)*sin(t*0.2),-0.1,0.1);//rotation limiter
	timeoff *= sign(sin(t*0.1));
	layerBrightness += 0.05;
	}
  
    fragColor = bcol;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

